# MySQL with environment variables 

This folder contains an example [Terraform](https://www.terraform.io/) configuration that deploys a MySQL database 
(using [RDS](https://aws.amazon.com/rds/)) in an [Amazon Web Services (AWS) account](http://aws.amazon.com/), passing
it the username and password using variables. 

For more info, please see Chapter 6, "Managing Secrets with Terraform", of 
*[Terraform: Up and Running](http://www.terraformupandrunning.com)*.

## Pre-requisites

* You must have [Terraform](https://www.terraform.io/) installed on your computer.
* You must have an [Amazon Web Services (AWS) account](http://aws.amazon.com/).

Please note that this code was written for Terraform 1.x.

## Quick start

**Please note that this example will deploy real resources into your AWS account. We have made every effort to ensure
all the resources qualify for the [AWS Free Tier](https://aws.amazon.com/free/), but we are not responsible for any
charges you may incur.**

Configure your [AWS access
keys](http://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys) as
environment variables:

```
export AWS_ACCESS_KEY_ID=(your access key id)
export AWS_SECRET_ACCESS_KEY=(your secret access key)
```

Configure the username and password for the master user of the database using environment variables:

```
export TF_VAR_db_username=(username)
export TF_VAR_db_password=(password)
```

Deploy the code:

```
terraform init
terraform apply
```

Clean up when you're done:

```
terraform destroy
```